 ; Ŀ
 ;   Yalf - freeze the layer containing a selected entity.                 
 ;   Copyright 1994, 2002, 2008 by Rocket Software Ltd.                    
 ;   Music has to hold your attention to be enjoyed.                       
 ;   Which means it has to be loud.                                        
 ;   Are there still shards of glass in your window frames?                
 ;   Are threads of your clothing still clinging to you?                   
 ;   Are there still patches of paint on your walls?                       
 ;   Then it isn't loud enough.                                            
 ; 

 ; Ŀ
 ;   Gnet - utility - find various data about a subentity.                 
 ; 
 (DEFUN C:GNET ()
  (if (setq enampt (nentsel "Entity: "))
      (progn
           (print enampt)
           (setq enam (car enampt))
           (print (type enam))
           (setq entt (entget enam))
           (write-line "\nEntity data:")
           (print entt)
           (if (assoc 330 entt)
               (progn
                    (write-line "\n330 (parent) data:")
                    (setq parent (cdr (assoc 330 entt)))
                    (print (entget parent))))
           (if (= (type (setq parnam (caar (reverse enampt)))) 'ename)
               (progn
                    (write-line "\nSuperclass entity data:")
                    (print (entget parnam))))))
 (princ))
 ; Ŀ
 ;   Gnet end.                                                             
 ; 

 ; Ŀ
 ;   Isxref: see if a given block is an xref.                              
 ;   Arguments: Blnam, either an entity name or a block name string.       
 ;   Returns T if the block was an xref, else nil.                         
 ; 
 (DEFUN ISXREF (blnam / dat xp isxrf)
  (if (= (type blnam) 'ename)
      (setq blnam (cdr (assoc 2 (entget blnam)))))
  (setq dat (tblsearch "block" blnam))
  (setq xp (cdr (assoc 70 dat)))
  (setq isxrf (logand xp 4))
 (if (= isxrf 4) T ()))
 ; Ŀ
 ;   Isxref end.                                                           
 ; 

 ; Ŀ
 ;   Nocur - if a named layer is current, switch to another.               
 ;   Arguments: Llay, a layer name.                                        
 ;   Calls nothing.                                                        
 ;   Returns 0 if no change was needed, 1 if one was made, and nil if      
 ;   a change was needed but couldn't be made.                             
 ;                                                                         
 ;   Note that since Nocur starts with layer 0 each time it is run, it     
 ;   will generally make 0 or one of the first few layers current - it     
 ;   doesn't care which layer you started from.                            
 ; 
 (DEFUN NOCUR (llay / rew nxnam stop next frz)
 ; Ŀ
 ;   If the current layer is the same as llay then step through the layer  
 ;   tables until we find one that is different and not frozen, then make  
 ;   that one current.                                                     
 ;   Note that if the current layer is the only one which isn't frozen,    
 ;   or if there is only one layer, Nocur will fail.                       
 ; 
  (if (= llay (getvar "clayer"))
      (progn
           (setq rew t)
 ; Ŀ
 ;   While there are layers and the stop flag isn't set.                   
 ; 
           (while (and (null stop) (setq next (tblnext "LAYER" rew)))
                  (setq nxnam (cdr (assoc 2 next)))
                  (setq rew nil)
 ; Ŀ
 ;   See if the layer being checked is llay, frozen, or part of an xref.   
 ; 
                  (setq frz (cdr (assoc 70 next)))
                  (if (not (or (= 1 (logand frz 1))     ; next is frozen
                               (= 16 (logand frz 16))   ; next is xref dep.
                               (= (strcase llay)
                                  (strcase nxnam))))    ; next = llay
                      (progn
                           (command "layer" "s" nxnam "")
                           (setq stop 1))))
           (if (null stop) (prompt "(Nocur) is unable to change layers.")))
      (setq stop 0))
 stop)
 ; Ŀ
 ;   Nocur end.                                                            
 ; 

 ; Ŀ
 ;   Yalf.                                                                 
 ; 
 (DEFUN C:YALF (/ snapp *error* enampt enam entt layy parent parnam)
  (setvar "cmdecho" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (defun *error* (shk /) (if snapp (setvar "snapmode" snapp)) (princ))
 ; Ŀ
 ;   Get an entity or subentity.                                           
 ; 
  (if (setq enampt (nentsel "Entity on layer to freeze: "))
      (progn
           (setq enam (car enampt))
           (setq entt (entget enam))
           (setq layy (cdr (assoc 8 entt)))
 ; Ŀ
 ;   If the entity was on a layer other than 0, freeze the layer.          
 ; 
           (cond ((/= layy "0")
                  (nocur layy)
                  (command "layer" "f" layy ""))
 ; Ŀ
 ;   If the entity wasn't nested - it wasn't a subentity of anything and   
 ;   wasn't an attribute - then freeze its layer.                          
 ;   Polyline vertices are also a non-nested subentity, but seem to be     
 ;   on the layer containing the parent entity.  Lwpolylines have only     
 ;   one layer group.                                                      
 ; 
                 ((and (= (length enampt) 2)
                       (/= (cdr (assoc 0 entt)) "ATTRIB"))
                  (nocur layy)
                  (command "layer" "f" layy ""))
 ; Ŀ
 ;   Ok, it is on layer 0, so if it was an attribute...judgement call...   
 ;   then assume that it is unlikely that it is nested and the user knows, 
 ;   so freeze the layer the parent block is on.                           
 ; 
                 ((= (cdr (assoc 0 entt)) "ATTRIB")
                  (setq parent (cdr (assoc 330 entt)))
                  (setq layy (cdr (assoc 8 (entget parent))))
                  (nocur layy)
                  (command "layer" "f" layy ""))
 ; Ŀ
 ;   If it was a block subentity then use the layer of the parent block.   
 ;   The final list (if the selected entity is nested) in the nentsel      
 ;   data list is the list of enames of the entities containing the        
 ;   selected one, in order from the one containing it directly on out.    
 ;   Again, judgement: use the one containing the selected entity, since   
 ;   it is hard to imagine putting a block on 0 and deliberately nesting   
 ;   it.  But is it really?  Could crawl outward until encountered a       
 ;   non-0 layer...                                                        
 ; 
                 ((> (length enampt) 2)
                  (setq parnam (caar (reverse enampt)))
                  (setq layy (cdr (assoc 8 (entget parnam))))
                  (nocur layy)
                  (command "layer" "f" layy ""))
 ; Ŀ
 ;   Anything else: freeze the layer it was on.                            
 ; 
                 (T 
                  (nocur layy)
                  (command "layer" "f" layy "")))))
 ; Ŀ
 ;   And let the user know what he has done.                               
 ; 
  (if layy (princ layy))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "snapmode" snapp)
 (princ))